#
# post_script.sh
#

#
# Move alibi from /mnt/databTMP to /mnt/auditTMP (audit) partition - if present.
# We need to make the mount points & mount them first.
#
mkdir -p /mnt/auditTMP
mkdir -p /mnt/databTMP
mount -o defaults,barrier=1 /dev/mmcblk0p2 /mnt/auditTMP
mount -o defaults,barrier=1 /dev/mmcblk0p3 /mnt/databTMP

# move alibi file if in wrong partition
if [ -f /mnt/databTMP/alibi ]; then
	mv -f /mnt/databTMP/alibi /mnt/auditTMP/alibi
fi
# sync before the delete - just in case
/bin/sync

# Remove contents of /mnt/databTMP (database) partition.
# rm -f /mnt/databTMP/*
# Check if the glob gets expanded to existing files.
# If not, 'file' here will be exactly the pattern we
# searched for and the 'exists' test will evaluate to false.
for file in /mnt/databTMP/*; do
	if [ -f "$file" ]; then
		rm -f $file
	fi
done

# Remove contents of /mnt/auditTMP (audit) partition
# except for: CRC, alibi and audit.
rm -f $(find /mnt/auditTMP -type f -not \( -name 'CRC' -or -name 'alibi' -or -name 'audit' \))

# This removes a CRC file of size zero.
# The file does exist, but is empty.
if [ ! -s /mnt/auditTMP/CRC ]; then
	rm /mnt/auditTMP/CRC
fi

# Create fptuser directory if it does not exist.
mkdir -p /mnt/ftpdir
mount -o defaults,barrier=1 /dev/mmcblk0p6 /mnt/ftpdir
if [ ! -d /mnt/ftpdir/ftpuser ]; then
	mkdir -p /mnt/ftpdir/ftpuser
	/bin/sync
fi

#
# Remove the following files for a clean system bring up.
# File system paths MUST be prefixed with /mnt/rootfs.
#
if [ -f /mnt/rootfs/home/qlx/cfg/parm.txt ]; then
	rm /mnt/rootfs/home/qlx/cfg/parm.txt
fi

if [ -f /mnt/rootfs/home/qlx/apps/startup.cod ]; then
	rm /mnt/rootfs/home/qlx/apps/startup.cod
fi

if [ -f /mnt/rootfs/home/qlx/cfg/StoredMemory ]; then
	rm /mnt/rootfs/home/qlx/cfg/StoredMemory
fi

# Check if the glob gets expanded to existing files.
# If not, 'file' here will be exactly the pattern we
# searched for and the 'exists' test will evaluate to false.
for file in /mnt/rootfs/home/qlx/cfg/ocds*; do
	if [ -e "$file" ]; then
		rm /mnt/rootfs/home/qlx/cfg/ocds*
	fi
	# This is all we needed to know, so we can break after the first iteration
	break
done

if [ -f /mnt/rootfs/home/qlx/cfg/qlxuihost.conf ]; then
	rm /mnt/rootfs/home/qlx/cfg/qlxuihost.conf
fi

/bin/sync

